import sys
import PIL
import requests
import torch
from diffusers import StableDiffusionXLImg2ImgPipeline
from PIL import Image
from diffusers.utils import load_image

def download_image(url):
    image = PIL.Image.open(requests.get(url, stream=True).raw)
    image = PIL.ImageOps.exif_transpose(image)
    image = image.convert("RGB")
    return image

def resize_image(image, target_size=(512, 512)):
    image = image.resize(target_size, Image.LANCZOS)
    return image

def generate_image(prompt, input_image_path, output_image_path):
    image = PIL.Image.open(input_image_path).convert("RGB")
    resized_image = resize_image(image)
    init_image = resized_image

    pipe = StableDiffusionXLImg2ImgPipeline.from_pretrained(
        "stabilityai/stable-diffusion-xl-refiner-1.0", torch_dtype=torch.float16, variant="fp16", use_safetensors=True
    )
    pipe = pipe.to("cuda")

    result_image = pipe(prompt, image=init_image).images[0]
    result_image.save(output_image_path)

if __name__ == "__main__":
    prompt = sys.argv[1]
    input_image_path = sys.argv[2]
    output_image_path = sys.argv[3]
    generate_image(prompt, input_image_path, output_image_path)
