const express = require("express");
const cors = require("cors");
const env = require("dotenv");
const path = require("path");
const upscaleRoute = require('./routes/upscale')
const cleanupJob = require('./scripts/cleanup');
const app = express();
app.use(cors()); 
env.config(); 
const rootDir = path.join(__dirname, "..");
const publicDir = path.join(rootDir, "public");
app.use("/public", express.static(publicDir));
const port = process.env.PORT || 8080;

app.use('/', upscaleRoute);
app.listen(port, () => {
  console.log(`Server is running on http://localhost:${port}`);
});
