const fs = require("fs");
const path = require("path");
const { spawn } = require("child_process");

const rootDir = path.join(__dirname, "../..");
const publicDir = path.join(rootDir, "public");

const processImage = (filePath, scale, retouch) => {
  return new Promise((resolve, reject) => {
    const child = spawn('node', [path.resolve(__dirname, "upscaleWorker.js"), JSON.stringify({ filePath, scale, retouch, publicDir })]);

    let outputData = '';
    let errorData = '';

    child.stdout.on('data', (data) => {
      outputData += data.toString();
    });

    child.stderr.on('data', (data) => {
      errorData += data.toString();
    });

    child.on('close', (code) => {
      if (code === 0) {
        const { outputFilePath } = JSON.parse(outputData.trim());
        resolve(outputFilePath);
      } else {
        reject(new Error(`Child process exited with code ${code}: ${errorData}`));
      }
    });
  });
};

exports.UploadAndUpscale = async (req, res) => {
  try {
    const scale = req.query.scale === "400%" ? 4 : 2;
    const retouch = req.query.retouch === "true";
    const files = req.files;

    const processedPaths = await Promise.all(
      files.map(async (file) => {
        const processedPath = await processImage(file.path, scale, retouch);
        fs.unlink(file.path, (err) => {
          if (err) console.error(`Failed to delete file ${file.path}:`, err);
        });
        return path.relative(publicDir, processedPath);
      })
    );

    res.json({
      message: "Images uploaded and processed successfully",
      paths: processedPaths.map((processedPath) => `public/${processedPath}`),
    });
  } catch (error) {
    console.error("Error processing image:", error);
    res.status(500).json({ error: "Failed to process the image", details: error.message });
  }
};
const generateImage = (prompt, inputImagePath, outputImagePath) => {
  return new Promise((resolve, reject) => {
    const process = spawn('python', ['image_generator.py', prompt, inputImagePath, outputImagePath]);

    process.stdout.on('data', (data) => {
      console.log(`stdout: ${data}`);
    });

    process.stderr.on('data', (data) => {
      console.error(`stderr: ${data}`);
    });

    process.on('close', (code) => {
      if (code !== 0) {
        return reject(new Error(`Failed to generate image. Process exited with code ${code}`));
      }
      resolve(outputImagePath);
      fs.unlink(inputImagePath, (err) => {
        if (err) console.error(`Failed to delete file ${inputImagePath}:`, err);
      });
    });
  });
};

exports.GenerateImage = async (req, res) => {
  try {
    const { prompt } = req.body;
    console.log(prompt);
    const inputImagePath = req.file.path;
    console.log("Path:", inputImagePath);
    const outputImagePath = path.join(publicDir, `generated-${req.file.filename}.png`);

    await generateImage(prompt, inputImagePath, outputImagePath);

    res.json({ imageUrl: `/public/${path.basename(outputImagePath)}` });
  } catch (error) {
    console.error('Error generating image:', error);
    res.status(500).json({ error: 'Failed to generate image', details: error.message });
  }
};
