const fs = require("fs");
const path = require("path");
const tf = require("@tensorflow/tfjs-node-gpu");
const Upscaler = require("upscaler/node-gpu");
const x2 = require("@upscalerjs/esrgan-medium/2x");
const x4 = require("@upscalerjs/esrgan-medium/4x");
const retouchingModel = require("@upscalerjs/maxim-retouching");

const { filePath, scale, retouch, publicDir } = JSON.parse(process.argv[2]);

const upscaleAndRetouchImage = async (filePath, scale, retouch) => {
  const upscaler = new Upscaler({
    model: scale === 4 ? x4 : x2,
    patchSize: 64,
    padding: 4,
  });

  const image = tf.node.decodeImage(fs.readFileSync(filePath), 3);
  let tensor = await upscaler.upscale(image);
 
  if (retouch) {
    console.log('retouching');
    const retoucher = new Upscaler({
      model: retouchingModel,
    });
    tensor = await retoucher.upscale(tensor);
  }

  const upscaledBuffer = await tf.node.encodePng(tensor);
  const outputFilePath = path.join(publicDir, `upscaled-${path.basename(filePath)}`);
  fs.writeFileSync(outputFilePath, upscaledBuffer);

  image.dispose();
  tensor.dispose();
  return outputFilePath;
};

upscaleAndRetouchImage(filePath, scale, retouch)
  .then((outputFilePath) => {
    console.log(JSON.stringify({ outputFilePath }));
    process.exit(0);
  })
  .catch((error) => {
    console.error(error);
    process.exit(1);
  });
