const express = require("express");
const router = express.Router();
const { UploadAndUpscale, UploadFilter, GenerateImage } = require("../controller/upscale");
const path = require("path");
const fs = require("fs");
const multer = require("multer");

const rootDir = path.join(__dirname, "../..");
const uploadsDir = path.join(rootDir, "uploads");
const publicDir = path.join(rootDir, "public");

if (!fs.existsSync(uploadsDir)) {
  fs.mkdirSync(uploadsDir);
}
if (!fs.existsSync(publicDir)) {
  fs.mkdirSync(publicDir);
}

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, uploadsDir);
  },
  filename: (req, file, cb) => {
    const uniqueName =
      Date.now() + "-" + file.originalname.replace(/\s+/g, "-").toLowerCase();
    cb(null, uniqueName);
  },
});

const upload = multer({
  storage,
  fileFilter: (req, file, cb) => {
    const filetypes = /jpeg|jpg|png|webp|avif/;
    const mimetype = filetypes.test(file.mimetype);
    const extname = filetypes.test(
      path.extname(file.originalname).toLowerCase()
    );
    if (mimetype && extname) {
      return cb(null, true);
    }
    cb("Error: Images Only!");
  },
  limits: { fileSize: 5 * 1024 * 1024 },
});

router.post("/upload", upload.array("images", 10), UploadAndUpscale);
router.post("/generate", upload.single("image"), GenerateImage); 
module.exports = router;
