const fs = require('fs');
const path = require('path');
const cron = require('cron');

const rootDir = path.join(__dirname, '../..');
const publicDir = path.join(rootDir, 'public');
const uploadsDir = path.join(rootDir, 'uploads');

const deleteOldFiles = (dir, maxAge) => {
  fs.readdir(dir, (err, files) => {
    if (err) {
      return console.error(`Unable to scan directory: ${err}`);
    }
    files.forEach((file) => {
      const filePath = path.join(dir, file);
      fs.stat(filePath, (err, stats) => {
        if (err) {
          return console.error(`Unable to get stats of file: ${err}`);
        }
        const now = Date.now();
        const age = now - stats.mtimeMs;
        if (age > maxAge) {
          fs.unlink(filePath, (err) => {
            if (err) {
              console.error(`Error deleting file: ${err}`);
            } else {
              console.log(`Deleted old file: ${filePath}`);
            }
          });
        }
      });
    });
  });
};


const job = new cron.CronJob('0 * * * *', () => {
  const maxAge = 2 * 60 * 60 * 1000;
  deleteOldFiles(publicDir, maxAge);
  deleteOldFiles(uploadsDir, maxAge);
});

job.start();

module.exports = job;
